#target photoshop

app.displayDialogs = DialogModes.NO;

var imageFiles = File.openDialog("Select images for moodboard", "*.jpg;*.jpeg;*.png;*.tif;*.tiff;*.webp", true);

if (imageFiles && imageFiles.length >= 2 && imageFiles.length <= 30) {
    imageFiles.sort();
    
    var landscapeCount = 0;
    for (var i = 0; i < imageFiles.length; i++) {
        app.open(imageFiles[i]);
        if (app.activeDocument.width > app.activeDocument.height) landscapeCount++;
        app.activeDocument.close(SaveOptions.DONOTSAVECHANGES);
    }
    
    var useLandscape = landscapeCount > imageFiles.length/2;
    var docWidth = useLandscape ? 3508 : 2480;
    var docHeight = useLandscape ? 2480 : 3508;
    var docRef = app.documents.add(docWidth, docHeight, 300, "Moodboard");
    
    var aspectRatio = docRef.height.value / docRef.width.value;
    var numImages = imageFiles.length;
    
    var bestRows = 0;
    var bestCols = 0;
    var bestRatio = 0;
    
    for(var rows = 2; rows <= Math.ceil(Math.sqrt(numImages * aspectRatio)); rows++) {
        var cols = Math.ceil(numImages / rows);
        var gridRatio = (rows * cols) / numImages;
        var orientationMatch = Math.abs((rows/cols) - aspectRatio);
        
        if (bestRows === 0 || (gridRatio < 1.2 && orientationMatch < bestRatio)) {
            bestRows = rows;
            bestCols = cols;
            bestRatio = orientationMatch;
        }
    }
    
    var cellWidth = docRef.width.value / bestCols;
    var cellHeight = docRef.height.value / bestRows;
    
    for (var i = 0; i < imageFiles.length; i++) {
        try {
            var col = i % bestCols;
            var row = Math.floor(i / bestCols);
            var targetX = col * cellWidth;
            var targetY = row * cellHeight;
            
            app.open(imageFiles[i]);
            var originalWidth = app.activeDocument.width;
            var originalHeight = app.activeDocument.height;
            app.activeDocument.selection.selectAll();
            app.activeDocument.selection.copy();
            app.activeDocument.close(SaveOptions.DONOTSAVECHANGES);
            
            docRef.paste();
            var imageLayer = docRef.activeLayer;
            
            imageLayer.translate(-imageLayer.bounds[0] + targetX, -imageLayer.bounds[1] + targetY);
            
            var widthRatio = cellWidth / originalWidth;
            var heightRatio = cellHeight / originalHeight;
            var scaleFactor = Math.min(widthRatio, heightRatio);
            
            imageLayer.resize(scaleFactor * 100, scaleFactor * 100, AnchorPosition.TOPLEFT);
        } catch(e) {
            alert("Error processing " + imageFiles[i].name + ": " + e);
        }
    }
    
    docRef.flatten();
    docRef.changeMode(ChangeMode.GRAYSCALE);

    // Apply Brightness/Contrast adjustment
    var idBrgC = charIDToTypeID("BrgC");
    var desc = new ActionDescriptor();
    var idBrgh = charIDToTypeID("Brgh");
    desc.putInteger(idBrgh, 25);
    var idIntr = charIDToTypeID("Cntr");
    desc.putInteger(idIntr, 25);
    executeAction(idBrgC, desc, DialogModes.NO);

    docRef.flatten();
} else {
    alert("Please select between 2 and 30 images.");
}